﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class PromotionDetailsBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static PromotionDetails GetItem(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            return PromotionDetailsDB.GetItem(promotionDetailsID, promotionID, productID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<PromotionDetails> GetList(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            return PromotionDetailsDB.GetList(promotionDetailsID, promotionID, productID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            return PromotionDetailsDB.GetDataTable(promotionDetailsID, promotionID, productID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            return PromotionDetailsDB.GetDataSet(promotionDetailsID, promotionID, productID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(PromotionDetails myPromotionDetails)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                PromotionDetailsDB.Save(myPromotionDetails);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
